﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class ResponseHistoryDataTable : DataTable
    {
        public ResponseHistoryDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("DATE", typeof(string)));
            this.Columns.Add(new DataColumn("TYPE", typeof(string)));
        }

        public ResponseHistoryDataRow this[int index]
        {
            get
            {
                return (ResponseHistoryDataRow)Rows[index];
            }
        }

        public void Add(ResponseHistoryDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(ResponseHistoryDataRow row)
        {
            this.Rows.Remove(row);
        }

        public ResponseHistoryDataRow GetNewRow()
        {
            ResponseHistoryDataRow row = (ResponseHistoryDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(ResponseHistoryDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new ResponseHistoryDataRow(builder);
        }

        public IEnumerator<ResponseHistoryDataRow> GetEnumerator()
        {
            List<ResponseHistoryDataRow> rows = new List<ResponseHistoryDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((ResponseHistoryDataRow)this.Rows[i]);
            }

            return rows.GetEnumerator();
        }
    }
}
